set -euo pipefail


N_CALLS=500
N_SUGGEST=1
N_REPEAT=5                
DB_ROOT=
LOG_DIR=


DBID=${DBID:-bm_full_$(date +%Y%m%d_%H%M%S)}


mkdir -p "$DB_ROOT" "$LOG_DIR"


export OMP_NUM_THREADS=${SLURM_CPUS_PER_TASK}
export MKL_NUM_THREADS=${SLURM_CPUS_PER_TASK}
export NUMEXPR_MAX_THREADS=${SLURM_CPUS_PER_TASK}

python - <<'PY'
import sys, shutil, numpy as np, sklearn
print("PY =", sys.executable)
print("BM =", shutil.which("bayesmark-launch"))
print("numpy =", np.__version__, "sklearn =", sklearn.__version__)
assert np.__version__.startswith("1."), "NumPy must be < 2.0"
PY


DATASETS=(breast digits iris wine diabetes)  
TID=${SLURM_ARRAY_TASK_ID}
DS_IDX=$(( TID / N_REPEAT ))
REP=$(( TID % N_REPEAT ))
DATA=${DATASETS[$DS_IDX]}

UUID=$(python - <<'PY'
import uuid; print(uuid.uuid4().hex)
PY
)

echo "DB_ROOT=$DB_ROOT"
echo "DBID=$DBID"
echo "ARRAY_ID=$TID  ->  DATA=$DATA  REP=$REP"
echo "UUID=$UUID"


bayesmark-launch \
  -dir "$DB_ROOT" -b "$DBID" \
  -o HyperOpt OpenTuner-BanditA OpenTuner-GA OpenTuner-GA-DE PySOT RandomSearch Scikit-GBRT-Hedge Scikit-GP-Hedge Scikit-GP-LCB \
  -c DT MLP-adam MLP-sgd RF \
  -d "$DATA" \
  -m acc mae mse nll \
  -n "$N_CALLS" -r 1 -p "$N_SUGGEST" \
  --uuid "$UUID" -v



